<?php
session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Área de clientes</title>

<!-- Bootstrap CSS -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

<style>
body {
    font-family: 'Arial', sans-serif;
    background-color: #f8f9fa;
}

#content {
    margin-left: 250px;
    padding: 20px;
    transition: margin-left 0.3s ease;
}

.user-card {
    border-radius: 8px;
    box-shadow: 0 0 15px rgba(0, 0, 0, 0.9);
    transition: transform 0.3s ease;
}

.user-card:hover {
    transform: translateY(-5px);
}

.card-body {
    padding: 20px;
}

.card-footer {
    display: flex;
    flex-wrap: wrap;
    gap: 10px;
    justify-content: center;
    padding-top: 15px;
}

.card-footer form, .card-footer a {
    flex: 1 1 45%;
}

.btn {
    width: 100%;
}
</style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <?php include 'laterais.php'; ?>

        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-md-4" id="content">
            <center><h1 class="mt-2 text-center">
               <i class="fas fa-user-friends" style="color: green;"></i> Todos Usuários
            </h1></center>

            <div class="search-bar mb-3">
                <input type="text" id="searchInput" class="form-control" placeholder="Pesquisar usuário..." onkeyup="searchUser()">
            </div>

            <div class="row">
            <?php
            $db_check = new SQLite3('.listausuarios.db');
            $db_check->exec('CREATE TABLE IF NOT EXISTS USERS(
                id INTEGER PRIMARY KEY AUTOINCREMENT,
                nome TEXT,
                descricao TEXT, 
                whatsapp TEXT, 
                datavencimento TEXT, 
                datainicio TEXT, 
                servidor TEXT, 
                conexao TEXT, 
                nomedoapk TEXT, 
                macdoapk TEXT, 
                chavedoapk TEXT, 
                tipodedispositivo TEXT, 
                indicacao TEXT
            )');

            $sql_listar = 'SELECT * FROM USERS ORDER BY datavencimento';
            $resultado = $db_check->query($sql_listar);

            if ($resultado) {
                while ($row = $resultado->fetchArray(SQLITE3_ASSOC)) {
                    $datavencimento = $row['datavencimento'];
                    $datainicio = $row['datainicio'];
                    $dataAtual = date('Y-m-d');
                    $diferenca = strtotime($datavencimento) - strtotime($dataAtual);
                    $diasFaltando = ceil($diferenca / (60 * 60 * 24));
                    $status = ($diasFaltando <= 0) ? " - <span class='text-danger'>Vencido</span>" : " - <span class='text-primary'>Em $diasFaltando dias</span>";
                    $dataFormatada_datainicio = (new DateTime($datainicio))->format('d/m/Y');
                    $dataFormatada_datavencimento = (new DateTime($datavencimento))->format('d/m/Y');  
                    $apenasNumeros = $row['whatsapp'];
                    $urlWhatsapp = "https://api.whatsapp.com/send?phone=" . urlencode($apenasNumeros) . "&text=" . urlencode("Olá *".$row['nome']."*, tudo bem?");

                    echo "
<div class='col-md-4 mb-4'>
    <div class='card user-card'>
        <div class='card-body'>
            <h5 class='card-title'><strong><i class='fa fa-user' style='color: #015e24;'></i> Cliente:</strong> <span class='text-primary'>{$row['nome']}</span></h5>
            <p class='card-text'>
                <strong><i class='fab fa-whatsapp' style='color: #015e24;'></i> Whatsapp:</strong> <span class='text-primary'>{$row['whatsapp']}</span><br>
                <strong><i class='fa fa-server'></i> Servidor:</strong> <span class='text-primary'>{$row['servidor']}</span><br>
                <strong><i class='fa fa-plug' style='color: #FF00FF;'></i> Conexão:</strong> <span class='text-primary'>{$row['conexao']}</span><br>
                <strong><i class='fa fa-mobile-alt' style='color: #007bff;'></i> Nome do APK:</strong> <span class='text-primary'>{$row['nomedoapk']}</span><br>
                <strong><i class='fa fa-network-wired'></i> MAC:</strong> <span class='text-primary'>{$row['macdoapk']}</span><br>
                <strong><i class='fa fa-key'></i> Chave do APK:</strong> <span class='text-primary'>{$row['chavedoapk']}</span><br>
                <strong><i class='fa fa-laptop'></i> Aparelho:</strong> <span class='text-primary'>{$row['tipodedispositivo']}</span><br>
                <strong><i class='fa fa-star'></i> Indicação:</strong> <span class='text-primary'>{$row['indicacao']}</span><br>
                <strong><i class='fa fa-money-bill-wave'></i> Valor:</strong> <span class='text-primary'>{$row['descricao']}</span><br>
                <strong><i class='fas fa-calendar'></i> Data inicial:</strong> <span class='text-primary'>{$dataFormatada_datainicio}</span><br>
                <strong><i class='fas fa-calendar'></i> Vence em:</strong> <span class='text-primary'>{$dataFormatada_datavencimento}</span> $status
            </p>
        </div>
        <div class='card-footer'>
            <a href='$urlWhatsapp' target='_blank' class='btn btn-outline-success'>
                <i class='fa-brands fa-whatsapp'></i> Whatsapp
            </a>
            <form action='editar.php' method='get'>
                <input type='hidden' name='option' value='editar'>
                <input type='hidden' name='id' value='{$row['id']}' required>
                <button type='submit' class='btn btn-primary'>✍🏻 Editar</button>
            </form>
            <form action='listausuarios.php' method='get'>
                <input type='hidden' name='option' value='apagar'>
                <input type='hidden' name='id' value='{$row['id']}' required>
                <button type='button' class='btn btn-danger' data-bs-toggle='modal' data-bs-target='#confirm-delete' data-href='listausuarios.php?option=apagar&id={$row['id']}'>🗑️ Excluir</button>
            </form>
            <form action='renovar.php' method='get'>
                <input type='hidden' name='id' value='{$row['id']}' required>
                <button type='submit' class='btn btn-success'>🔄 Renovar</button>
            </form>
        </div>
    </div>
</div>";
                }
            } else {
                echo "<div class='alert alert-danger'>Erro na consulta: " . $db_check->lastErrorMsg() . "</div>";
            }
            ?>
            </div>
        </main>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>

<script>
function normalizeText(text) {
    return text.normalize("NFD").replace(/[\u0300-\u036f]/g, "").replace(/[^a-zA-Z0-9]/g, '').toUpperCase();
}

function searchUser() {
    var input, filter, cards, cardContainer, i, txtValue;
    input = document.getElementById("searchInput");
    filter = normalizeText(input.value);
    cardContainer = document.getElementById("content");
    cards = cardContainer.getElementsByClassName("user-card");
    for (i = 0; i < cards.length; i++) {
        txtValue = normalizeText(cards[i].textContent || cards[i].innerText);
        cards[i].style.display = (txtValue.indexOf(filter) > -1) ? "" : "none";
    }
}

$('#confirm-delete').on('show.bs.modal', function (e) {
    $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
});
</script>
</body>
</html>
