<?php
session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}

// Conectar ao banco de dados e contar os usuários vencidos
$db_check = new SQLite3('.listausuarios.db');

// Conta a quantidade de usuários vencidos
$sql_count = "SELECT COUNT(*) as total_vencidos FROM USERS WHERE DATE(datavencimento) <= DATE('now', '-0 days')";
$resultado_count = $db_check->query($sql_count);
$total_vencidos = $resultado_count->fetchArray(SQLITE3_ASSOC)['total_vencidos'];
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Clientes Inativos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <style>
        body { background-color: #f4f6f9; }
        .page-title { text-align: center; margin: 15px 0; }
        .user-card { border-radius: 12px; box-shadow: 0 6px 12px rgba(0,0,0,0.9); padding: 15px; margin-bottom: 20px; background: #fff; }
        .user-card:hover { transform: translateY(-5px); box-shadow: 0 8px 16px rgba(0,0,0,0.9); }
        .status-icon { position: absolute; top: 5px; right: 10px; font-size: 1.2rem; color: red; }
        .btn { width: 100%; margin-top: 5px; }
    </style>
</head>
<body>

<div class="container-fluid">
    <div class="row">
        <?php include 'laterais.php'; ?>
        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-md-4" id="content">
            <center>
                <h1 class="page-title"><i class="fa fa-calendar text-danger"></i> INATIVOS</h1>
                <p><i class="fas fa-users text-primary"></i> Total de Usuários Inativos: <strong><?php echo $total_vencidos; ?></strong></p>
            </center>

            <div class="search-bar mb-3">
                <input type="text" id="searchInput" class="form-control" placeholder="Pesquisar usuário..." onkeyup="searchUser()">
            </div>

            <?php
            $sql_listar = 'SELECT * FROM USERS ORDER BY datavencimento DESC';
            $resultado = $db_check->query($sql_listar);

            if ($resultado) {
                echo '<div class="row">';
                while ($row = $resultado->fetchArray(SQLITE3_ASSOC)) {
                    $datavencimento = $row['datavencimento'];
                    $dataAtual = new DateTime();
                    $dataVencimento = new DateTime($datavencimento);
                    $diferenca = $dataAtual->diff($dataVencimento)->days;

                    if ($dataVencimento > $dataAtual || $diferenca < 1) continue;

                    $data_datainicio = (new DateTime($row['datainicio']))->format('d/m/Y');
                    $data_datavencimento = $dataVencimento->format('d/m/Y');

                    $apenasNumeros = preg_replace('/\D/', '', $row['whatsapp']);
                    if (strlen($apenasNumeros) < 11) $apenasNumeros = "55" . $apenasNumeros;

                    $mensagem = urlencode("Olá *".$row['nome']."*, tudo bem? \n\nVerifiquei que sua assinatura venceu em *".$data_datavencimento."*. Que tal reativar seu plano na *LOBOPLAY*? \n\nAtt: *RICK*");
                    $whatsappLink = 'https://wa.me/' . htmlspecialchars($apenasNumeros) . '?text=' . $mensagem;

                    echo '<div class="col-md-4 mb-4">';
                    echo '<div class="user-card position-relative">';
                    echo '<div class="status-icon"><i class="fas fa-times-circle"></i></div>';
                    echo '<div class="card-body">';
                    echo '<center><h5 class="card-title">👤 ' . htmlspecialchars($row['nome']) . '</h5></center>';
                    echo '<p>✅ Ativado em: ' . $data_datainicio . '</p>';
                    echo '<p>⛔ Expirado em: ' . $data_datavencimento . '</p>';
                    echo '<a href="' . $whatsappLink . '" class="btn btn-success" target="_blank"><i class="fab fa-whatsapp"></i> Enviar mensagem</a>';
                    echo '<a href="renovar.php?id=' . $row['id'] . '" class="btn btn-primary"><i class="fas fa-redo"></i> Renovar +30 dias</a>';
                    echo '</div>';
                    echo '</div>';
                    echo '</div>';
                }
                echo '</div>';
            } else {
                echo '<p class="text-danger">Erro ao acessar o banco de dados.</p>';
            }
            ?>
        </main>
    </div>
</div>

<script>
function searchUser() {
    var input = document.getElementById("searchInput").value.toUpperCase();
    var cards = document.getElementsByClassName("col-md-4");
    for (let i = 0; i < cards.length; i++) {
        let title = cards[i].getElementsByClassName("card-title")[0];
        cards[i].style.display = title.innerHTML.toUpperCase().includes(input) ? "" : "none";
    }
}
</script>

</body>
</html>
