<?php
session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="Gestor de clientes.">
    <meta name="keywords" content="gestor, cadastro, cliente">
    <meta name="author" content="NANTV">
    <meta name="robots" content="index, follow">
    <link rel="icon" href="imagem/logo.png" type="image/png">
    <title>Painel administrativo</title>
    
    <!-- Metatags Open Graph -->
    <meta property="og:title" content="Gestor Lobo">
    <meta property="og:description" content="Gestor de clientes">
    <meta property="og:image" content="imagem/logo.png">
    <meta property="og:url" content=https://gestor.pnox.xyz">
    <meta property="og:type" content="website">
    
    <!-- Metatags do Twitter -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="Gestor NANTV">
    <meta name="twitter:description" content="Gestor de clientes">
    <meta name="twitter:image" content="imagem/logo.png">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- FontAwesome CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
</head>
<body>
    <!-- Seu conteúdo -->
</body>
</html>

<!-- Google Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500&display=swap" rel="stylesheet">

<style>
    body {
        font-family: 'Roboto', sans-serif;
        background-color: #f4f6f9;
        margin: 0;
        padding: 0;
    }
    
    #sidebar {
        background-color: #343a40;
        color: #fff;
        height: 100vh;
        padding-top: 20px;
    }
    
    #sidebar .nav-link {
        color: #fff;
        font-weight: 500;
    }
    
    #sidebar .nav-link:hover {
        color: #007bff;
        background-color: #495057;
    }
    
    #content {
        padding: 20px;
    }
    
    .page-title {
        text-align: center;
        margin-top: 1px;
        margin-bottom: 10px;
        font-size: 2rem;
        font-weight: 600;
        color: #343a40;
    }
    
    .message-container {
        background-color: #d4edda;
        border: 5px solid #c3e6cb;
        border-radius: 15px;
        padding: 10px;
        margin-bottom: 20px;
        color: #155724;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.9);
    }
    
    .message-containerErro {
        background-color: #f8d7da;
        border: 1px solid #f5c6cb;
        border-radius: 8px;
        padding: 20px;
        margin-bottom: 20px;
        color: #721c24;
        box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    }
    
   .search-bar {
    margin-bottom: 15px;
    position: relative;
   }

    .search-bar input {
    border: 2px solid #007bff; /* Cor da borda */
    border-radius: 4px; /* Borda arredondada */
    padding: 10px; /* Espaçamento interno */
    font-size: 1rem; /* Tamanho da fonte */
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.8); /* Sombra */
    transition: border-color 0.3s, box-shadow 0.3s; /* Transição suave */
    }

    .search-bar input:focus {
    border-color: #0056b3; /* Cor da borda quando em foco */
    box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2); /* Sombra mais forte quando em foco */
    outline: none; /* Remove o contorno padrão */
    }

    
    .user-card {
        border-radius: 12px;
        box-shadow: 0 6px 12px rgba(0, 0, 0, 0.9);
        padding: 1px;
        margin-bottom: 20px;
        background-color: #fff;
        position: relative;
        overflow: hidden;
        transition: transform 0.3s, box-shadow 0.3s;
    }
    
    .user-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.9);
    }
    
    .user-card h5 {
        margin-bottom: 10px;
        color: #007bff
        font-size: 1.25rem;
    }
    
    .user-card .status-icon {
        position: absolute;
        top: 1px;
        right: 1px;
        font-size: 1rem;
    }
    
    .user-card .icon-warning {
        color: #ff9800;
    }
    
    .user-card .icon-error {
        color: #f44336;
    }
    
    @media (max-width: 768px) {
        .user-card {
            padding: 15px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.9);
        }
        
        .user-card .status-icon {
            font-size: 1.5rem;
            top: 1px;
            right: 1px;
        }
    }
    
</style>

<body>

<div class="container-fluid">
    <div class="row">
        <!-- Barra lateral -->
        <?php include 'laterais.php'; ?>

        <!-- Conteúdo principal -->
        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-md-4" id="content">
            <center>
                <br>
                <h1 class="page-title">
                 <i class="fa fa-calendar" style="color: red;"></i> Expirados e Vencendo
                </h1>
               <p>
             <i class="fas fa-users" style="color: blue;"></i> 
              <span style="color: SaddleBrown;">Usuários com 1 dia a expirar ou vencidos</span>
             </p>
             
            </center>

            <!-- Barra de pesquisa -->
            <div class="search-bar">
                <input type="text" id="searchInput" class="form-control" placeholder="Pesquisar usuário..." onkeyup="searchUser()">
            </div>

            <?php
            $db_check = new SQLite3('.listausuarios.db');
            $sql_listar = 'SELECT * FROM USERS';
            $resultado = $db_check->query($sql_listar);

            if ($resultado) {
                echo '<div class="row">';
                while ($row = $resultado->fetchArray(SQLITE3_ASSOC)) {
                    $datavencimento = $row['datavencimento'];
                    
                    $dataAtual = date('Y-m-d');
                    $diferenca = strtotime($datavencimento) - strtotime($dataAtual);
                    $diasFaltando = ceil($diferenca / (60 * 60 * 24));

                    // Condição para exibir usuários vencidos ou vencendo em até 1 dias
                    if ($diasFaltando > 1 || $diasFaltando < -0) {
                        continue; // Pular usuários com mais de 1 dia do vencimento e menos de 0 dia
                    }

                    $status = ($diasFaltando <= 0) ? "Vencido" : "Expirando";
                    
                    $statusColor = ($diasFaltando <= 0) ? "#f44336" : "#ff9800";
                    $statusIconClass = ($diasFaltando <= 0) ? "icon-error" : "icon-warning";

                    $data_datainicio = new DateTime($row['datainicio']);
                    $dataFormatada_datainicio = $data_datainicio->format('d/m/Y');
                                
                    $data_datavencimento = new DateTime($datavencimento);
                    $dataFormatada_datavencimento = $data_datavencimento->format('d/m/Y');  
                     
                    $apenasNumeros = $row['whatsapp'];

                    // Determina a mensagem com base no status
                    $mensagem = ($diasFaltando <= 0) ? 
                        "⚠️ *ATENÇÃO* ⚠️\n\nOlá Sr(a) *".$row['nome']."*, tudo bem? \n\nMeu contato é referente ao vencimento da sua assinatura de *IPTV* que encontra-se desativada desde o dia *".$dataFormatada_datavencimento."*\n\nSe desejar reativar o acesso, basta digitar o número *4* que lhe envio os dados do PIX e faço a reativação.\n\nAtt: *Rick*\n\nRede: *Loboplay*" :
                        "🛎 *Lembrete automático* 🛎\n\nOlá Sr(a) *".$row['nome']."*, tudo bem? \n\nMeu contato é referente ao vencimento da sua assinatura de *IPTV* que vence dia *".$dataFormatada_datavencimento."* e expirará a qualquer hora do dia.\n\nPara renovar, basta digitar o número *4* que lhe envio os dados do PIX.\n\n_Se possível, não deixe expirar o acesso para renovar. Após expirado a demora pode ser um pouco maior do que o normal.\n\nAtt: *Rick*\n\nRede: *Loboplay*";
                    
                    $urlWhatsapp = "https://api.whatsapp.com/send?phone=" . urlencode($apenasNumeros) . "&text=" . urlencode($mensagem);
                    
                    echo "
                    <div class=\"col-lg-3 col-md-4 col-sm-6 mb-4\">
                        <div class=\"user-card\">
                            <span class=\"status-icon {$statusIconClass}\">
                                <i class=\"fas " . ($status === "Vencido" ? "fas fa-ban" : "fa-clock") . "\"></i>
                            </span>
                            <h6>👤 Cliente: {$row['nome']}</h6>
                            <p>🌐 Servidor: {$row['servidor']}</p>
                            <p>📆 Vencimento: {$dataFormatada_datavencimento}</p>
                            <p>⚠️ Status: <span style='color: $statusColor;'>$status</span></p>
                            <center><a href=\"$urlWhatsapp\" target=\"_blank\" class=\"btn btn-primary\">Enviar Mensagem</a></center>
                        </div>
                    </div>
                    ";
                }
                echo '</div>'; // Fecha a linha
            } else {
                echo "<p>Erro ao consultar o banco de dados ou nenhum usuário para exibir.</p>";
            }
            ?>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>
<script>
    function searchUser() {
        var input, filter, cards, cardContainer, i, txtValue;
        input = document.getElementById('searchInput');
        filter = input.value.toUpperCase();
        cardContainer = document.querySelectorAll('.user-card');
        
        for (i = 0; i < cardContainer.length; i++) {
            txtValue = cardContainer[i].querySelector('h6').textContent;
            if (txtValue.toUpperCase().indexOf(filter) > -1) {
                cardContainer[i].style.display = "";
            } else {
                cardContainer[i].style.display = "none";
            }
        }
    }
</script>

</body>
</html>