<?php
session_start();

if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header("Location: listausuarios.php?msg=id_invalido");
    exit();
}

$id = (int) $_GET['id'];

// Conecta no banco
$db = new SQLite3('.listausuarios.db');

// Garante integridade
$db->exec('PRAGMA foreign_keys = ON');

// Apaga o usuário
$stmt = $db->prepare("DELETE FROM USERS WHERE id = :id");
$stmt->bindValue(':id', $id, SQLITE3_INTEGER);
$stmt->execute();

if ($db->changes() > 0) {
    header("Location: listausuarios.php?msg=excluido");
} else {
    header("Location: listausuarios.php?msg=erro");
}
exit();
