<?php
ini_set("display_errors", 1);
ini_set("display_startup_errors", 1);

session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}

// Função para sanitizar entradas de texto
function sanitizeInput($input) {
    return htmlspecialchars(trim($input), ENT_QUOTES, 'UTF-8');
}

// Conexão principal
$db = new SQLite3('.admin.db');

// Função para atualizar usuário
function atualizarUsuario($usuario, $senha) {
    $db = new SQLite3('.admin.db');
    $stmt = $db->prepare('UPDATE USERS SET USERNAME = :usuario, PASSWORD = :senha WHERE id = 1');

    $stmt->bindValue(':usuario', $usuario, SQLITE3_TEXT);
    $stmt->bindValue(':senha', $senha, SQLITE3_TEXT);

    if ($stmt->execute()) {
        echo "<script>alert('O perfil foi alterado com sucesso.');</script>";
        echo "<script>window.location.href='perfil.php';</script>";
    } else {
        echo "<script>alert('Erro ao atualizar o perfil.');</script>";
        echo "<script>window.location.href='perfil.php';</script>";
    }

    $db->close();
}

// Se for salvar
if (isset($_GET["option"]) && $_GET["option"] == "salvar") {
    $usuario = sanitizeInput($_POST['usuario']);
    $senha = sanitizeInput($_POST['senha']);

    if (!empty($usuario) && !empty($senha)) {
        atualizarUsuario($usuario, $senha);
    } else {
        echo "<script>alert('Erro: preencha todos os campos.');</script>";
    }
}

// Busca dados do usuário
$sql_check = 'SELECT * FROM USERS WHERE id = 1';
$ret_check = $db->query($sql_check);

$usuario = "";
$senha = "";
$NAME = "";

if ($ret_check) {
    if ($row_check = $ret_check->fetchArray(SQLITE3_ASSOC)) {
        $NAME = $row_check['NAME'];
        $usuario = $row_check['USERNAME'];
        $senha = $row_check['PASSWORD'];
    }
} else {
    echo "<p style='color:red'>Erro: tabela USERS não encontrada no banco .admin.db</p>";
}

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ajuste de acesso</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f8f9fa;
            color: #333;
        }
        #sidebar { background-color: #343a40; color: #fff; height: 100vh; }
        #content {
            padding: 40px;
            background-color: #fff;
            border-radius: 15px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            margin-top: 20px;
        }
        h1 { font-size: 2.5rem; text-align: center; color: #007bff; margin-bottom: 40px; }
        p { text-align: center; font-size: 1.2rem; color: #6c757d; margin-bottom: 30px; }
        form {
            background-color: #fff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            max-width: 600px;
            margin: auto;
        }
        form label { font-weight: bold; margin-bottom: 10px; color: #495057; }
        form input {
            width: 100%; padding: 10px; margin-bottom: 15px;
            border: 1px solid #ced4da; border-radius: 15px;
            font-size: 1rem; transition: border-color 0.3s;
        }
        form input:focus {
            border-color: #007bff;
            box-shadow: 0 0 5px rgba(0, 123, 255, 0.5);
            outline: none;
        }
        form button {
            width: 100%; padding: 10px;
            background-color: #000; color: #fff;
            border: none; border-radius: 5px;
            font-size: 1.2rem; cursor: pointer;
            transition: background-color 0.3s ease;
        }
        form button:hover { background-color: #28a745; }
        @media (max-width: 768px) {
            form { padding: 20px; }
            h1 { font-size: 2rem; }
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <?php include 'laterais.php'; ?>
            <main role="main" class="col-md-9 col-lg-10 px-md-4" id="content">
                <h1>Área de ajuste de acesso</h1>
                <p>Gerencie seu acesso ao painel:</p>
                <form action="perfil.php?option=salvar" method="post">
                    <label for="usuario"><i class="fas fa-user"></i> Usuário:</label>
                    <input type="text" id="usuario" value="<?php echo $usuario; ?>" name="usuario" required>
                    
                    <label for="senha"><i class="fas fa-key"></i> Senha:</label>
                    <input type="text" id="senha" value="<?php echo $senha; ?>" name="senha" required>
                                        
                    <button type="submit">Atualizar</button>
                </form>
            </main>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
