<?php
session_start();

// Proteção simples - só logado entra
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}

$arquivo = __DIR__ . "/mensagens.json";

// Carregar mensagens
$mensagens = json_decode(file_get_contents($arquivo), true);

// Salvar alterações
if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $mensagens["vencido"] = $_POST["vencido"];
    $mensagens["aviso"]   = $_POST["aviso"];

    file_put_contents($arquivo, json_encode($mensagens, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
    $msg = "Mensagens atualizadas com sucesso!";
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Editar Mensagens Automáticas</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container py-4">
    <h2>✍️ Editar Mensagens Automáticas</h2>
    <?php if (!empty($msg)) echo "<div class='alert alert-success'>$msg</div>"; ?>

    <form method="post">
        <div class="mb-3">
            <label class="form-label">Mensagem de Cliente Vencido</label>
            <textarea class="form-control" name="vencido" rows="6"><?= htmlspecialchars($mensagens['vencido']) ?></textarea>
        </div>

        <div class="mb-3">
            <label class="form-label">Mensagem de Aviso Pré-Vencimento</label>
            <textarea class="form-control" name="aviso" rows="6"><?= htmlspecialchars($mensagens['aviso']) ?></textarea>
        </div>

        <button type="submit" class="btn btn-primary">Salvar Alterações</button>
    </form>
</body>
</html>
