<?php
session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Área de clientes</title>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f8f9fa;
        }
        
        #content {
            margin-left: 250px;
            padding: 20px;
            transition: margin-left 0.3s ease;
        }


/* Estilização do Modal */
.modal-content {
    border-radius: 15px; /* Bordas arredondadas */
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.5); /* Sombra suave */
    border: none; /* Remover borda padrão */
    overflow: hidden; /* Evitar que conteúdo ultrapasse as bordas arredondadas */
}

.custom-modal-position {
    margin-top: 200px; /* Ajuste a margem superior conforme necessário */
    
}   

.modal-header {
    background-color: #007bff; /* Cabeçalho azul */
    color: #fff; /* Texto branco */
    padding: 20px; /* Espaçamento */
    border-bottom: none; /* Remover borda inferior */
}

.modal-header h2 {
    margin: 0;
    font-size: 1.8rem;
    font-weight: bold;
}

.modal-body {
    padding: 30px; /* Mais espaçamento */
    color: #555; /* Cor de texto suave */
    font-size: 1.1rem; /* Aumenta o tamanho do texto */
    line-height: 1.6; /* Melhor espaçamento entre linhas */
}

.modal-footer {
    padding: 15px 30px; /* Ajuste de espaçamento */
    background-color: #f1f1f1; /* Fundo mais claro */
    border-top: none; /* Remover borda superior */
    display: flex;
    justify-content: flex-end; /* Botões alinhados à direita */
}

.modal-footer .btn {
    border-radius: 20px; /* Botões arredondados */
    padding: 10px 20px; /* Botões mais largos */
    font-weight: bold; /* Texto mais forte */
    transition: all 0.3s ease; /* Transição suave para o hover */
}

.modal-footer .btn-secondary {
    background-color: #6c757d;
    color: #fff;
    border: none;
}

.modal-footer .btn-secondary:hover {
    background-color: #5a6268; /* Cor de hover */
}

.modal-footer .btn-danger {
    background-color: #dc3545;
    color: #fff;
    border: none;
}

.modal-footer .btn-danger:hover {
    background-color: #c82333; /* Cor de hover */
}

/* Animação ao abrir o modal */
.modal.fade .modal-dialog {
    transition: transform 0.3s ease-out, opacity 0.3s ease-out;
    transform: translate(0, -50px);
    opacity: 0;
}

.modal.fade.show .modal-dialog {
    transform: translate(0, 0);
    opacity: 1;
}

        
        .message-container {
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
            border-radius: 4px;
            padding: 15px;
            margin-bottom: 20px;
            color: #155724;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);
        }
        
        .message-containerErro {
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            border-radius: 4px;
            padding: 15px;
            margin-bottom: 20px;
            color: #721c24;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.5);
        }
        
        .search-bar {
    margin-bottom: 20px;
    position: relative;
}

        .user-card {
            border-radius: 8px;
            box-shadow: 0 0 15px rgba(0, 0, 0, 0.9);
            transition: transform 0.3s ease;
        }
        
        .user-card:hover {
            transform: translateY(-5px);
        }
        
        
        .card-body {
    padding: 20px;
        }

        .card-footer {
    display: flex; /* Usa flexbox para alinhar os botões */
    justify-content: space-between; /* Espaçamento uniforme entre os botões */
    align-items: center; /* Alinha verticalmente os itens */
    padding-top: 15px; /* Espaçamento superior para os botões */
    gap: 10px; /* Espaço entre os botões */
        }

        
        .card-title {
            font-size: 1.5rem;
            margin-bottom: 1rem;
        }
        
        .btn-outline-success {
            border-color: #28a745;
            color: #28a745;
        }
        
        .btn-outline-success:hover {
            background-color: #28a745;
            color: #fff;
        }
        
        .modal-header h2 {
            font-size: 1.5rem;
        }
        .modal-content {
            border-radius: 20px;
        }
        
        .modal-footer .btn {
            border-radius: 4px;
        }
        

        /* Responsividade */
        
    </style>
</head>
<body>

<!-- Modal de confirmação de exclusão -->
<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <div class="modal-dialog custom-modal-position"> <!-- Classe adicionada aqui -->
        <div class="modal-content">
            <div class="modal-header">
                <h2>ATENÇÃO</h2>
            </div>
            <div class="modal-body">
                Tem certeza de que deseja excluir este cliente?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">CANCELAR</button>
                <a class="btn btn-danger btn-ok" href="#">SIM</a>
            </div>
        </div>
    </div>
</div>


<div class="container-fluid">
    <div class="row">
        <?php include 'laterais.php'; ?>

        <!-- Conteúdo -->
        <main role="main" class="col-md-9 ml-sm-auto col-lg-10 px-md-4" id="content">
            <center><h1 class="mt-2 text-center">
               <i class="fas fa-user-friends" aria-hidden="true" style="color: green;"></i> Todos Usuários
            </h1></center>

            <div class="search-bar">
                <input type="text" id="searchInput" class="form-control" placeholder="Pesquisar usuário..." onkeyup="searchUser()">
            </div>

            <p>
                <?php
                
                if (isset($_GET["option"]) && $_GET["option"] == "apagar") {
                    $id = $_GET['id'];

                    if (!empty($id) && is_numeric($id)) {

                        $db_check = new SQLite3('.listausuarios.db');

                        $db_check->exec('CREATE TABLE IF NOT EXISTS USERS(
                          id INTEGER PRIMARY KEY AUTOINCREMENT,
                          nome TEXT,
                          descricao TEXT, 
                          whatsapp TEXT, 
                          datavencimento TEXT, 
                          datainicio TEXT, 
                          servidor TEXT, 
                          conexao TEXT, 
                          nomedoapk TEXT, 
                          macdoapk TEXT, 
                          chavedoapk TEXT, 
                          tipodedispositivo TEXT, 
                          indicacao TEXT
                          )');

                        $stmt = $db_check->prepare('DELETE FROM USERS WHERE id = :id');
                        $stmt->bindValue(':id', $id, SQLITE3_INTEGER);

                        if ($stmt->execute()) {
                            echo "<script>alert('Usuário deletado com sucesso.');</script>";
                            echo "<script>window.location.href='listausuarios.php?option=iniciar';</script>";
                        } else {
                            echo "<script>alert('Erro ao deletar o usuário.');</script>";
                            echo "<script>window.location.href='listausuarios.php?option=iniciar';</script>";
                        }
                    } else {
                        echo "<script>alert('Usuário inválido.');</script>";
                        echo "<script>window.location.href='listausuarios.php?option=iniciar';</script>";
                    }
                }

                if ($_GET["option"] == "iniciar") {
                    $nome = isset($_POST['nome']) ? $_POST['nome'] : '';
                   $apagar = isset($_GET['apagar']) ? $_GET['apagar'] : '';
                    $apagarconfirmado = isset($_GET['apagarconfirmado']) ? $_GET['apagarconfirmado'] : '';

                     $nomeUsuario = $_GET['nomeUsuario'] ?? ''; 
                    $nomeUsuarioGETConfirmado = $_GET['nomeconfirmado'] ?? ''; {
                        $db_check = new SQLite3('.listausuarios.db');
                        $db_check->exec('CREATE TABLE IF NOT EXISTS USERS(
                            id INTEGER PRIMARY KEY AUTOINCREMENT,
                            nome TEXT,
                            descricao TEXT, 
                            whatsapp TEXT, 
                            datavencimento TEXT, 
                            datainicio TEXT, 
                            servidor TEXT, 
                            conexao TEXT, 
                            nomedoapk TEXT, 
                            macdoapk TEXT, 
                            chavedoapk TEXT, 
                            tipodedispositivo TEXT, 
                            indicacao TEXT
                            )');

                        $result = $db_check->querySingle('SELECT COUNT(*) AS total FROM USERS');
                        echo "<center><div class=\"message-container\">Total de clientes cadastrados: <strong>" . $result . "</strong></div></center>";

                        $sql_listar = ($nomeUsuario == "")
                        ? "SELECT * FROM USERS ORDER BY (CASE WHEN datavencimento < date('now') THEN 1 ELSE 0 END), datavencimento"
                      : "SELECT * FROM USERS WHERE macdoapk LIKE '%$nomeUsuario%' ORDER BY (CASE WHEN datavencimento < date('now') THEN 1 ELSE 0 END), datavencimento";

                        $resultado = $db_check->query($sql_listar);

                        if ($resultado) {
                            echo '<div class="row">';
                            while ($row = $resultado->fetchArray(SQLITE3_ASSOC)) {
                                $datavencimento = $row['datavencimento'];
                                $datainicio = $row['datainicio'];
                                
                                $servidor = $row['servidor'];
                                
                                $dataAtual = date('Y-m-d');
                                
                                $diferenca = strtotime($row['datavencimento']) - strtotime($dataAtual);
                                $diasFaltando = ceil($diferenca / (60 * 60 * 24));

                                $diasFaltandoInt = $diasFaltando;
                                
                                if ($diasFaltando <= 0) {
                                    $diasFaltando = " - <span class=\"text-danger\">Vencido</span>";
                                } else {
                                    $diasFaltando = " - <span class=\"text-primary\">Em $diasFaltando dias</span>";
                                }

                                $data_datainicio = new DateTime($datainicio);
                                $dataFormatada_datainicio = $data_datainicio->format('d/m/Y');
                                
                                $data_datavencimento = new DateTime($datavencimento);
                                $dataFormatada_datavencimento = $data_datavencimento->format('d/m/Y');  
                                                         
                                $apenasNumeros = $row['whatsapp'];

                    // Determina a mensagem com base no Nome
                    $mensagem = "Olá *".$row['nome']."*, tudo bem?";
                    
                    $urlWhatsapp = "https://api.whatsapp.com/send?phone=" . urlencode($apenasNumeros) . "&text=" . urlencode($mensagem);

                                echo "
<div class=\"col-md-4 mb-4\">
    <div class=\"card user-card\">
        <div class=\"card-body\">
            
            <h5 class=\"card-title\"><strong><i class=\"fa fa-user\"style=\"color: #015e24;\"></i> Cliente:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['nome']) . "</span></h5>
            
            <p class=\"card-text\">
            
                <strong><i class=\"fab fa-whatsapp\"style=\"color: #015e24;\"></i> Whatsapp:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['whatsapp']) . "</span>
                
                <br>
                
                <strong><i class=\"fa fa-server\" style=\"color: #343635;\"></i> Servidor:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['servidor']) . "</span>
                
                <br>
                
                <strong><i class=\"fa fa-plug\" style=\"color: #FF00FF;\"></i> Conexão:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['conexao']) . "</span>
                
                <br>
                
                <strong><i class=\"fa fa-mobile-alt\" style=\"color: #007bff;\"></i> Nome do APK:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['nomedoapk']) . "</span>
                
                <br>
                
                <strong><i class=\"fa fa-network-wired\" style=\"color: #F4A460;\"></i> MAC:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['macdoapk']) . "</span>
                
                <br>
                
                <strong><i class=\"fa fa-key\" style=\"color: #8B4513;\"></i> Chave do APK:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['chavedoapk']) . "</span>
                
                <br>
                
                <strong><i class=\"fa fa-laptop\" style=\"color: #007bff;\"></i>  Aparelho:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['tipodedispositivo']) . "</span>
                <br>
                
                <strong><i class=\"fa fa-star\" style=\"color: #DAA520;\"></i>  Indicação:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['indicacao']) . "</span><br>
                
                
                <strong><i class=\"fa fa-money-bill-wave\" style=\"color: #006400;\"></i>  Valor:</strong> <span class=\"text-primary\">" . htmlspecialchars($row['descricao']) . "</span>
                <br>
                
                <strong><i class=\"fas fa-calendar\" style=\"color: #016125;\"></i>  Data inicial:</strong> <span class=\"text-primary\">" . htmlspecialchars($dataFormatada_datainicio) . "</span>
                
                <br>
                
                <strong><i class=\"fas fa-calendar\" style=\"color: #FF0000;\"></i>  Vence em:</strong> <span class=\"text-primary\">" . htmlspecialchars($dataFormatada_datavencimento) . "</span>" . $diasFaltando . "
            
    </p>
        </div>
        <div class=\"card-footer\">
            <a href=\"$urlWhatsapp\" target=\"_blank\" class=\"btn btn-outline-success\">
    <i class=\"fa-brands fa-whatsapp\"></i> Whatsapp
             </a>

            <form action=\"editar.php\" method=\"get\" class=\"d-inline\">
                <input type=\"hidden\" name=\"option\" value=\"editar\">
                <input type=\"hidden\" name=\"id\" value=\"" . htmlspecialchars($row['id']) . "\" required>
                <button type=\"submit\" class=\"btn btn-primary\">✍🏻 Editar</button>
            </form>
            <form action=\"listausuarios.php\" method=\"get\" class=\"d-inline\">
                <input type=\"hidden\" name=\"option\" value=\"apagar\">
                <input type=\"hidden\" name=\"id\" value=\"" . htmlspecialchars($row['id']) . "\" required>
                <button type=\"button\" class=\"btn btn-danger\" data-bs-toggle=\"modal\" data-bs-target=\"#confirm-delete\" data-href=\"listausuarios.php?option=apagar&id=" . htmlspecialchars($row['id']) . "\">🗑️ Excluir</button>
            </form>
        </div>
    </div>
</div>
";

                            }
                            echo '</div>'; // Fecha a div.row
                        } else {
                            echo "<div class=\"message-containerErro\">Erro na consulta: " . $db_check->lastErrorMsg() . "</div>";
                        }
                    }
                }
                ?>
            </p>
        </main>
    </div>
</div>

<!-- jQuery (necessário para o modal funcionar) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<!-- Bootstrap JS e dependências -->
<script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.min.js"></script>

<script>


function normalizeText(text) {
    // Remove acentuação e caracteres especiais, e transforma em maiúsculas
    return text.normalize("NFD").replace(/[\u0300-\u036f]/g, "").replace(/[^a-zA-Z0-9]/g, '').toUpperCase();
}

function searchUser() {
    var input, filter, cards, cardContainer, i, txtValue;
    input = document.getElementById("searchInput");
    filter = normalizeText(input.value);
    cardContainer = document.getElementById("content");
    cards = cardContainer.getElementsByClassName("user-card");
    for (i = 0; i < cards.length; i++) {
        txtValue = normalizeText(cards[i].textContent || cards[i].innerText);
        if (txtValue.indexOf(filter) > -1) {
            cards[i].style.display = "";
        } else {
            cards[i].style.display = "none";
        }
    }
}

    
    $('#confirm-delete').on('show.bs.modal', function (e) {
        $(this).find('.btn-ok').attr('href', $(e.relatedTarget).data('href'));
    });
</script>

</body>
</html>


<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
