<?php
session_start();

if (!isset($_SESSION["usuario_digitado"])) {
    
    header("Location: login.php");
    exit();
}

function clientes() {
    if ($_SESSION['painelselecionado'] == "") {
        return;
    }
    $painelselecionado = $_SESSION['painelselecionado'];
    $conteudoDiretorio = scandir($painelselecionado);
    $quantidade = -1;
    foreach ($conteudoDiretorio as $item) {
        if ($item != "." && $item != "..") {
            if (is_dir($painelselecionado . '/' . $item)) {
                $quantidade++;
            }
        }
    }
    echo "<p>Usuários: " . $quantidade . "</p>";
}

function bloqueados() {
    if ($_SESSION['painelselecionado'] == "") {
        return;
    }
    $painelselecionado = $_SESSION['painelselecionado'];
    $conteudoDiretorio = scandir($painelselecionado);
    $quantidade = 0;
    foreach ($conteudoDiretorio as $item) {
        if ($item != "." && $item != "..") {
            if (is_dir($painelselecionado . '/' . $item)) {
                if (is_dir($painelselecionado . '/' . $item . '/bloqueado')) {
                    $quantidade++;
                }
            }
        }
    }
    echo "<p>Bloqueados: " . $quantidade . "</p>";
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel de Controle</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        body {
            font-family: 'Roboto', sans-serif;
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        
        #topbar {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            background-color: #343a40;
            color: white;
            padding: 10px 20px;
            z-index: 1100;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        #topbar .logo-container {
            margin: 0;
        }

        #topbar .logo {
            height: 40px;
        }

        
        #sidebar {
            background-color: #343a40;
            min-height: 100vh;
            padding-top: 20px;
            position: fixed;
            top: 50px; 
            left: 0;
            width: 250px; 
            z-index: 1000;
            transition: transform 0.3s ease-in-out;
        }

        
        #content {
            margin-left: 250px;
            margin-top: 50px;
            padding: 20px;
        }

        
        .logo-container {
            text-align: center;
            margin-bottom: 20px;
            padding: 0 10px;
            box-sizing: border-box;
        }

        
        .logo {
            width: 50px;
            height: auto;
            display: block;
            margin: 0 auto;
        }

        .nav {
            margin: 0;
            padding: 0;
            list-style: none;
        }

        .nav-item {
            margin-bottom: 1rem;
        }

        .nav-link {
            display: block;
            font-size: 1.1rem;
            padding: 15px 20px;
            position: relative;
            border: 2px solid transparent;
            border-radius: 5px;
            background-color: #343a40;
            color: #fff;
            transition: color 0.3s, border-color 0.3s;
            overflow: hidden;
        }

        .nav-link::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            border: 2px solid transparent;
            border-left-color: #007bff;
            border-right-color: #007bff;
            border-top: none;
            border-bottom: none;
            border-radius: 5px;
            pointer-events: none;
            box-sizing: border-box;
        }

        .nav-link:hover {
            background-color: #495057;
        }

        .nav-link:hover::before {
            border-color: #007bff;
        }

        .nav-link i {
            vertical-align: middle;
            margin-right: 8px;
        }

       
        #menu-toggle {
            display: none; 
            position: absolute;
            top: 10px;
            left: 80px;
            background-color: #343a40;
            color: white;
            border: none;
            padding: 10px;
            font-size: 1.5rem;
            width: 50px;
            height: 50px;
            border-radius: 50%;
            text-align: center;
            line-height: 30px;
            z-index: 1100;
        }

        
        @media (max-width: 767.98px) {
            #sidebar {
                transform: translateX(-100%);
                width: 75%; 
            }

            #menu-toggle {
                display: block; 
            }

            
            #sidebar.active {
                transform: translateX(0);
            }

            #content {
                margin-left: 0;
            }
        }
    </style>
</head>
<body>


<div id="topbar">
    <div class="logo-container">
        <a href="imagem/logo.png" target="_blank">
            <img src="imagem/logo.png" alt="Logo" class="logo">
        </a>
    </div>
    <button id="menu-toggle" class="btn btn-dark d-md-none">
        <i class="fas fa-bars"></i>
    </button>
</div>


<nav id="sidebar" class="col-md-3 col-lg-2 d-md-block bg-dark text-white">
    <div class="sidebar-sticky">
        
        <ul class="nav flex-column">
<li class="nav-item">
    <a class="nav-link text-white active" href="index.php">
        <i class="fas fa-check-circle" style="color: #007bff;"></i>
        Status
    </a>
</li>
            
            <style>
@keyframes pulse {
    0% {
        transform: scale(1);
        opacity: 1;
    }
    50% {
        transform: scale(1.2);
        opacity: 0.7;
    }
    100% {
        transform: scale(1);
        opacity: 1;
    }
}

.animated-icon {
    animation: pulse 1.5s infinite;
}
</style>
            
            
            
<li class="nav-item">
    <a class="nav-link text-white" href="listausuarios.php?option=iniciar">
        <i class="fas fa-users animated-icon" style="color: #28a745;"></i>
        Usuários IPTV
    </a>
</li> 

<li class="nav-item">
    <a class="nav-link text-white" href="listausuarios.php?option=iniciar">
        <i class="fas fa-users animated-icon" style="color: #28a745;"></i>
        Usuários Paineis
    </a>
</li>        

<li class="nav-item">
    <a class="nav-link text-white" href="inativos.php">
        <i class="fa fa-power-off" style="color: #fc031c;"></i>
        Expirados
    </a>
</li>     
            
<li class="nav-item">
    <a class="nav-link text-white" href="criar.php">
        <i class="fas fa-user-plus animated-icon" style="color: #ffc107;"></i>
       Usuário iptv
    </a>
</li>      

<li class="nav-item">
    <a class="nav-link text-white" href="registro.php">
        <i class="fas fa-user-plus animated-icon" style="color: #ffc107;"></i>
        Usuário painel
    </a>
</li>  
            
<li class="nav-item">
    <a class="nav-link text-white" href="grafico.php">
        <i class="fas fa-chart-line animated-icon" style="color: #17a2b8;"></i>
        Gráficos
    </a>
</li>            
            
            
<li class="nav-item">
<a class="nav-link text-white" href="perfil.php">
        <i class="fas fa-user animated-icon" style="color: #17a2b8;"></i>
        Perfil
    </a>
</li>
            
<li class="nav-item">
    <a class="nav-link text-white" href="logout.php">
        <i class="fas fa-sign-out-alt animated-icon" style="color: #dc3545;"></i>
        Sair
    </a>
</li>           
            
        </ul>
    </div>
</nav>





<script>
     document.getElementById("menu-toggle").addEventListener("click", function() {
            var sidebar = document.getElementById("sidebar");
            sidebar.classList.toggle("active");
        });
    </script>
</body>
</html>
