<?php
ini_set("display_errors", 1);
ini_set("display_startup_errors", 1);

session_start();

// Verifica se o usuário está autenticado
if (!isset($_SESSION["usuario_digitado"])) {
    header("Location: login.php");
    exit();
}

// Conexão com o banco de dados
$db = new SQLite3('.listausuarios.db');

// Proteção contra SQL Injection
$dataAtual = date('Y-m-d');

$ativos = $db->querySingle("SELECT COUNT(*) FROM USERS WHERE datavencimento > '$dataAtual'");
$expirando = $db->querySingle("SELECT COUNT(*) FROM USERS WHERE datavencimento <= date('$dataAtual', '+5 days') AND datavencimento > '$dataAtual'");
$expirados = $db->querySingle("SELECT COUNT(*) FROM USERS WHERE datavencimento <= '$dataAtual'");
$totalUsuarios = $db->querySingle("SELECT COUNT(*) FROM USERS");

?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gráfico</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- FontAwesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css" rel="stylesheet">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            background-color: #f4f6f9;
        }
        .dashboard-container {
            padding: 30px;
        }
        h1 {
            text-align: center;
            margin-bottom: 40px;
        }
        .card {
            border-radius: 12px;
            box-shadow: 0 6px 12px rgba(0, 0, 0, 0.1);
            margin-bottom: 20px;
            display: flex;
            align-items: center;
            height: 120px;
            position: relative;
        }
        .card .card-body {
            flex: 1;
            padding-left: 20px;
        }
        .card-title {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 10px;
        }
        .card-text {
            font-size: 1rem;
            color: #343a40;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
        }
        .card-border {
            width: 10px;
            height: 100%;
            position: absolute;
            left: 0;
            top: 0;
            border-radius: 12px 0 0 12px;
        }
        .bg-success .card-border {
            background-color: #28a745;
        }
        .bg-warning .card-border {
            background-color: #ffc107;
        }
        .bg-danger .card-border {
            background-color: #dc3545;
        }
        .bg-primary .card-border {
            background-color: #007bff;
        }
        .icon {
            font-size: 2rem;
            margin-right: 20px;
        }
        .chart-container {
            margin: 0 auto;
            width: 100%;
            max-width: 400px;
            position: relative;
            height: 200px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 3.0);
        }
        canvas {
            max-width: 100%;
        }
        .user-data {
            margin-top: 20px;
            font-size: 0.875rem;
            text-align: center;
            width: 100%;
            margin-left: auto;
            margin-right: auto;
        }
        .user-data .row {
            margin-bottom: 10px;
        }
        .user-data .col-md-3 {
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 0;
        }



        /* Responsividade */
        @media (max-width: 767.98px) {
            .card {
                height: auto;
                flex-direction: column;
                text-align: center;
            }
            .card .card-body {
                padding-left: 0;
                padding-right: 0;
            }
            .chart-container {
                height: 250px;
            }
        }
    </style>
</head>
<body>
    
<div class="container-fluid">
    <div class="row">
        <?php include 'laterais.php'; ?>

        <!-- Conteúdo -->
        <main role="main" class="col-md-9 ml-sm-auto" id="content">
            <h1><i class="fa fa-line-chart"></i> Gráfico de clientes</h1>

            <!-- Cards -->
            <div class="row">
                <div class="col-md-3 col-sm-6 mb-4">
                    <div class="card bg-light">
                        <div class="card-border bg-primary"></div>
                        <div class="card-body d-flex align-items-center">
                            <i class="fas fa-users icon text-primary"></i>
                            <div>
                                <h5 class="card-title">Total</h5>
                                <p class="card-text"><?php echo $totalUsuarios; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6 mb-4">
                    <div class="card bg-light">
                        <div class="card-border bg-success"></div>
                        <div class="card-body d-flex align-items-center">
                            <i class="fas fa-users icon text-success"></i>
                            <div>
                                <h5 class="card-title">Ativos</h5>
                                <p class="card-text"><?php echo $ativos; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6 mb-4">
                    <div class="card bg-light">
                        <div class="card-border bg-warning"></div>
                        <div class="card-body d-flex align-items-center">
                            <i class="fas fa-hourglass-half icon text-warning"></i>
                            <div>
                                <h5 class="card-title">A Expirar</h5>
                                <p class="card-text"><?php echo $expirando; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-3 col-sm-6 mb-4">
                    <div class="card bg-light">
                        <div class="card-border bg-danger"></div>
                        <div class="card-body d-flex align-items-center">
                            <i class="fas fa-user-times icon text-danger"></i>
                            <div>
                                <h5 class="card-title">Expirados</h5>
                                <p class="card-text"><?php echo $expirados; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Gráfico e Informações -->
            <div class="row">
                <div class="col-md-12">
                    <div class="chart-container">
                        <canvas id="userBarChart"></canvas>
                    </div>
                    <div class="user-data">
                        <div class="row">
                            <div class="col-md-3"><strong>Total: </strong> <?php echo $totalUsuarios; ?></div>
                            <div class="col-md-3"><strong>Ativos: </strong> <?php echo $ativos; ?></div>
                            <div class="col-md-3"><strong>A Expirar:</strong> <?php echo $expirando; ?></div>
                            <div class="col-md-3"><strong>Expirados: </strong> <?php echo $expirados; ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</div>


<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- Script para o Gráfico de Barras -->
<script>
    const ctx = document.getElementById('userBarChart').getContext('2d');
    const userBarChart = new Chart(ctx, {
        type: 'bar',
        data: {
            labels: ['Total', 'Ativos', 'A Expirar', 'Expirados'],
            datasets: [{
                label: 'Total',
                data: [<?php echo $totalUsuarios; ?>, <?php echo $ativos; ?>, <?php echo $expirando; ?>, <?php echo $expirados; ?>],
                backgroundColor: ['#007bff', '#28a745', '#ffc107', '#dc3545'],
                borderColor: ['#0056b3', '#1e7e34', '#e0a800', '#c82333'],
                borderWidth: 1
            }]
        },
        options: {
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });
</script>
</body>
</html>
